# README: Implementation of Hydra Branch and One-to-Many Relation Assignment

This repository contains two key Python files that implement core components of our proposed method.

## 1. Hydra Branch and RelDecoder Layer (`decoder_layer.py`)

This file contains the implementation of our Hydra Branch and RelDecoder layer. 

## 2. One-to-Many Relation Assignment (`one_to_many.py`)

This file implements our One-to-Many Relation Assignment strategy. Key components include:

- `Matcher` class: Assigns ground truth labels to predictions based on quality matrices.
- `Stage2AssignerRel` class: Implements the core of our One-to-Many assignment strategy.
- `sample_topk` function: Selects top-k matches for each ground truth.

The assignment process includes:
- Cost matrix computation considering both subject and object predictions
- Proposal matching and sampling
- Post-processing to ensure diverse and high-quality assignments


